/**
 *
 * \file        leds.c
 *
 * \brief       Common led routines
 *
 * \author      Pete McCormick
 *
 * \date        12/5/2007
 *
 */

////////////////////////////////////////////////////////////////////////////////

#include "os.h"
#include "leds.h"
#include "console.h"
#include "string_utils.h"
#include <stdlib.h>

////////////////////////////////////////////////////////////////////////////////
#define LED_TIMER_MS 500

// move this elsewhere soon
void LedsTask(UINT32 param)
{
    static BOOL toggle;

    if(toggle)
    {
        LedControl(LED_HEARTBEAT, 0);
        toggle = 0;
    }
    else
    {
        LedControl(LED_HEARTBEAT, 1);
        toggle = 1;
    }
}

void LedsInit(void)
{
    OsStartTimer(LED_TIMER_MS, (void*)LedsTask, OS_TIMER_PERIODIC);
}

void LedCmdPrintUsage(void)
{
}

INT32 LedCmd(UINT32 ignore, char * cmd)
{
    char * argv[2];
    UINT32 argc;
    UINT32 ledNum;
    BOOL on;

    if (*cmd == '?')                   // print help string
    {
        DmConsolePrintf("LED {NUMBER{ {ON|OFF}");
        LedCmdPrintUsage();
        return 0;
    }

    StringParseArgs(cmd, argv, sizeof(argv)/sizeof(argv[0]), &argc);

    if(argc < 2)
    {
        return -1;
    }

    ledNum = atoi(argv[0]);

    if(stricmp(argv[1], "on") == 0)
    {
        on = 1;
    }
    else
    {
        on = 0;
    }

    LedControl(ledNum, on);

    return 0;
}


